import InputError from '@/components/input-error';
import LoadingButton from '@/components/loading-button';
import { Input } from '@/components/ui/input';
import { Textarea } from '@/components/ui/textarea';
import { onHandleChange } from '@/lib/inertia';
import { SharedData } from '@/types/global';
import { useForm, usePage } from '@inertiajs/react';

const FaqForm = ({ faq }: { faq: CourseFaq }) => {
   const { props } = usePage<SharedData>();
   const { translate } = props;
   const { input, button } = translate;

   const {
      data,
      setData,
      put,
      delete: destroy,
      errors,
      processing,
   } = useForm({
      question: faq ? faq.question : '',
      answer: faq ? faq.answer : '',
   });

   const handleSubmit = (e: React.FormEvent) => {
      e.preventDefault();

      put(route('faqs.update', { faq: faq.id }));
   };

   const handleDelete = () => {
      destroy(route('faqs.destroy', { faq: faq.id }));
   };

   return (
      <form onSubmit={handleSubmit} className="space-y-2">
         <div>
            <Input
               required
               type="text"
               name="question"
               value={data.question || ''}
               placeholder={input.question}
               onChange={(e) => onHandleChange(e, setData)}
            />

            <InputError message={errors.question} />
         </div>

         <div>
            <Textarea required name="answer" value={data.answer || ''} placeholder={input.answer} onChange={(e) => onHandleChange(e, setData)} />

            <InputError message={errors.question} />
         </div>

         <div className="flex items-center justify-end gap-2">
            <LoadingButton
               type="button"
               variant="outline"
               loading={processing}
               onClick={handleDelete}
               className="h-7 w-full bg-red-50 text-xs hover:bg-red-100"
            >
               {button.remove}
            </LoadingButton>
            <LoadingButton variant="secondary" className="h-7 w-full text-xs" loading={processing}>
               {button.save}
            </LoadingButton>
         </div>
      </form>
   );
};

export default FaqForm;
